;;; GNUS-FILTER.EL --- add spammers to killfile

;; Copyright (C) 1997 Kevin Davidson

;; Author: Kevin Davidson <EMAIL: PROTECTED>
;; Maintainer: Kevin Davidson <EMAIL: PROTECTED>
;; Created: 10 Jan 1997
;; Version: $Revision: 1.4 $
;; Keywords:

 
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; A copy of the GNU General Public License can be obtained from this
;; program`s author (send electronic mail to <EMAIL: PROTECTED>) or
;; from the Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
;; MA 02139, USA.

;; LCD Archive Entry:
;; gnus-filter|Kevin Davidson|<EMAIL: PROTECTED>
;; |add spammers to killfile
;; |$Date: 1997/11/21 11:06:39 $|$Revision: 1.4 $|~/packages/gnus-filter.el

;;; Commentary:
;; This package allows you to keep your regexps for junk mail senders
;; in a separate file and provides a simple method of adding new spammers
;; to the list.

;; Future mail from these addresses will go to gnus-filter-newsgroup, which you
;; should define first:
;; eg.  G m mail.junk RET nnml RET in the *Group* buffer (assuming you use 
;;      nnml as your mail back end).
;; Edit the group properties to make the group total-expire and set
;; expiry-wait to 1 or immediate.

;; Once you`ve got the newsgroup, add this to .gnus.el or .emacs.el
;; (autoload `gnus-filter-init "gnus-filter")
;; (gnus-filter-init)
;; (add-hook `gnus-summary-mode-hook `(lambda ()
;;                                      (local-set-key "J" `gnus-filter-map)))

;; Now, whenever you encounter spam mail, hit `J a` in the *Summary* buffer
;; Edit the regexp if required (often it`s a good idea to remove the user and
;; junk mail from the whole site eg: cyberpromo.com) and hit return.
;; If you think the Subject of the message will catch more spam, then use 
;; `J s` to define that subject as spam. Again, you`ll get the chance to modify
;; the final regexp.
;; If you make a mistake, or a spammer reforms and becomes a good netizen,
;; you can remove entries from the list with `J r`.

;;; Change log:
;; $Log: gnus-filter.el,v $
;; 8.10.2001 Jan Borsodi
;; Fixed the regex concat.
;; Added support for moving the email to the spam newsgroup
;;
;; Revision 1.4  1997/11/21 11:06:39  tkld
;; Add support for spam subjects. Use a real keymap.
;;
;; Revision 1.3  1997/11/21 10:50:42  tkld
;; Added support for removing reformed spammers. Use J as a keymap for
;; future junk related commands.
;;
;; Revision 1.2  1997/01/23  13:23:52  tkld
;; Reworked as a function to add to nnmail-split-methods instead of
;; modifying the split-methods directly. Regexps stored as a list to make
;; editing easier.
;;
;; Revision 1.1  1997/01/10  17:16:53  tkld
;; Initial revision
;;

;;; Code:

(defconst gnus-filter-version (substring "$Revision: 1.4 $" 11 -2)
  "$Id: gnus-filter.el,v 1.4 1997/11/21 11:06:39 tkld Exp $

Report bugs to: Kevin Davidson <EMAIL: PROTECTED>")

(defvar gnus-filter-spamfile 
  (concat gnus-directory "SPAM")
  "*Mail global kill file")

(defvar gnus-filter-newsgroup
  "mail.junk"
  "*Newsgroup to send spam to.")

(defvar gnus-filter-backend
  "nnfolder"
  "*Backend the newsgroup is in.")

(defvar gnus-filter-regexp-list 
  `("^Subject:.*MAKE MONEY FAST")
  "*List of regular expressions matching the headers of a spam message")

(defvar gnus-filter-move-to-newsgroup
  nil
  "*If non-nil move the mail to the spam newsgroup")

(defvar gnus-filter-map (make-sparse-keymap))

(define-key gnus-filter-map "a" `gnus-filter-add-spammer)
(define-key gnus-filter-map "r" `gnus-filter-remove-spammer)
(define-key gnus-filter-map "s" `gnus-filter-add-spam-subject)

(defun gnus-filter-init ()
  "Set up spam list"
  (interactive "")
  (if (file-exists-p gnus-filter-spamfile)
      (load gnus-filter-spamfile))
  (gnus-filter-update-split-methods))


(defun gnus-filter-add-spam-subject ()
  "Add current subject to spam list regexp"
  (interactive)
  (let* ((subject (read-string
                  "Add spam subject (regexp): "
                  (if (vectorp gnus-current-headers)
                      (regexp-quote (mail-header-subject gnus-current-headers))
                    "MAKE MONEY FAST")))
         (regex (concat "^Subject:.*" subject)))
    (setq gnus-filter-regexp-list (cons regex gnus-filter-regexp-list))
    (save-excursion
      (set-buffer gnus-summary-buffer)
      (gnus-summary-execute-command "Subject" subject "E"))
    (gnus-filter-update-spamfile)))


(defun gnus-filter-add-spammer ()
  "Add current author to spam list regexp"
  (interactive)
  (let* ((author (read-string
                  "Add spammer (regexp): "
                  (if (vectorp gnus-current-headers)
                      (regexp-quote (mail-header-from gnus-current-headers))
                    "Mr Spam")))
         (regex (concat "^From:.*" author)))
    (setq gnus-filter-regexp-list (cons regex gnus-filter-regexp-list))
    (save-excursion
      (set-buffer gnus-summary-buffer)
      (gnus-summary-execute-command "From" author "E")
      (if gnus-filter-move-to-newsgroup
	  (gnus-summary-move-article nil (concat gnus-filter-backend ":" gnus-filter-newsgroup) nil)))
    (gnus-filter-update-spamfile)))

(defun gnus-filter-remove-spammer (spammer)
  "Remove a reformed spammer from spam list."
  (interactive (list (completing-read "Spammer: "
                                      (mapcar (function (lambda (el)
                                                          (cons el nil)))
                                              gnus-filter-regexp-list)
                                      nil t)))
  (setq gnus-filter-regexp-list (delete spammer gnus-filter-regexp-list))
  (gnus-filter-update-spamfile))

(defun gnus-filter-update-spamfile ()
  "Save updated spam regexp to gnus-filter-spamfile"
  (let ((buffer (find-file-noselect gnus-filter-spamfile)))
    (save-excursion
      (set-buffer buffer)
      (erase-buffer)
      (insert "(setq gnus-filter-regexp-list `")
      (insert (prin1-to-string gnus-filter-regexp-list))
      (insert ")")
      (let ((version-control nil))
        (write-file gnus-filter-spamfile nil)))))

;;;   (setq nntest-split-methods `(("mail.foo" "foo") ("mail.misc" "")))


(defun gnus-filter-spamp (group)
  "Test current message headers t detect spam"
  (let ((spam-regex (mapconcat `identity gnus-filter-regexp-list "\\|")))
    (goto-char (point-min))
    (not (null (re-search-forward spam-regex (point-max) t nil)))))

(defun gnus-filter-update-split-methods ()
  "Hook gnus-filter into nnmail-split-methods"
  (let* ((old (assoc gnus-filter-newsgroup nnmail-split-methods)))
    (if old
        (setq nnmail-split-methods
              (cons (list gnus-filter-newsgroup `gnus-filter-spamp)
                    (delete old
                            nnmail-split-methods)))
      (setq nnmail-split-methods
            (cons (list gnus-filter-newsgroup `gnus-filter-spamp)
                    nnmail-split-methods)))))
            

(provide 'gnus-filter)

;;; GNUS-FILTER.EL ends here
